# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

from openerp import models, fields, api

PARAMS = [
    ("fiscal_position_date_start", "itis_temporary_fiscal_position.fiscal_position_date_start"),
    ("fiscal_position_date_stop", "itis_temporary_fiscal_position.fiscal_position_date_stop"),
]

class account_config_settings(models.TransientModel):
    _inherit = 'account.config.settings'

    fiscal_position_date_start = fields.Date(string='Start date')
    fiscal_position_date_stop = fields.Date(string='End date')

    @api.multi
    def set_params(self):
        self.ensure_one()

        for field_name, key_name in PARAMS:
            value = getattr(self, field_name, '').strip()
            self.env['ir.config_parameter'].set_param(key_name, value)

    def get_default_params(self, cr, uid, fields, context=None):
        res = {}
        for field_name, key_name in PARAMS:
            res[field_name] = self.pool.get('ir.config_parameter').get_param(cr,uid, key_name, '').strip()
        return res