# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

from openerp import models, fields, SUPERUSER_ID, api, _
from openerp.osv import osv
from datetime import datetime
from openerp.exceptions import ValidationError
from openerp.tools import DEFAULT_SERVER_DATETIME_FORMAT, float_compare

class SaleOrder(models.Model):
    _inherit = 'sale.order'

    new_fiscal_position_id = fields.Many2one('account.fiscal.position', string='Temporary fiscal position')

    @api.model
    def apply_old_tax(self):
        fiscal_pool = self.env['account.fiscal.position']
        context = dict(self._context)
        for record in self.search([('id', 'in', context.get('active_ids'))]):
            if record.state != 'draft':
                raise ValidationError(_("You can only apply old tax on draft records."))
            new_fiscal_position = record.new_fiscal_position_id
            if new_fiscal_position:
                for line in record.order_line:
                    taxes = []
                    for tax in line.tax_id:
                        taxes.append(tax.id)
                        for fo_tax in new_fiscal_position.tax_ids:
                            if fo_tax.tax_dest_id and tax.id == fo_tax.tax_dest_id.id:
                                if tax.id in taxes:
                                    taxes.remove(tax.id)
                                taxes.append(fo_tax.tax_src_id.id)    
                    line.tax_id = [(6, 0, list(set(taxes)))]
            record.new_fiscal_position_id = False
        return True

class sale_order(osv.osv):
    _inherit = "sale.order"

    def apply_fiscal_position(self, cr, uid, ids, context=None):
        fiscal_pool = self.pool.get('account.fiscal.position')
        records = self.search(cr, uid, [('id', 'in', context.get('active_ids'))])
        records = self.browse(cr, uid, records, context=context)
        for record in records:
            if record.state != 'draft':
                raise ValidationError(_("You can only apply temporary fiscal position on draft records."))
            if record.partner_id.new_property_account_position:
                record.new_fiscal_position_id = record.partner_id.new_property_account_position.id
                for line in record.order_line:
                    tax_ids = fiscal_pool.map_tax(cr, uid, record.partner_id.new_property_account_position, line.tax_id, context=context)
                    line.tax_id = [(6, 0, tax_ids)]
        return True

    def onchange_partner_id(self, cr, uid, ids, part, date_order=None, context=None):
        result = super(sale_order, self).onchange_partner_id(cr, uid, ids, part=part, context=context)
        partner_id = self.pool.get('res.partner').browse(cr, uid, part, context=context)
        result['value'].update({'new_fiscal_position_id': False})
        date_ref = datetime.now().date().strftime('%Y-%m-%d')
        if date_order:
            date_ref = str(datetime.strptime(date_order, DEFAULT_SERVER_DATETIME_FORMAT).date())
        if partner_id and partner_id.new_property_account_position:
            from_date = self.pool.get('ir.config_parameter').get_param(cr, SUPERUSER_ID, 'itis_temporary_fiscal_position.fiscal_position_date_start')
            to_date = self.pool.get('ir.config_parameter').get_param(cr, SUPERUSER_ID, 'itis_temporary_fiscal_position.fiscal_position_date_stop')
            if from_date and to_date and from_date <= date_ref and to_date >= date_ref:
                result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
            elif not from_date and to_date and to_date >= date_ref:
                result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
            elif from_date and not to_date and from_date <= date_ref:
                result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
            elif not from_date and not to_date:
                result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
            else:
                result['value'].update({'new_fiscal_position_id': False})
        return result

    def action_invoice_create(self, cr, uid, ids, grouped=False, states=None, date_invoice = False, context=None):
        result = super(sale_order, self).action_invoice_create(cr, uid, ids, grouped=grouped, states=states, date_invoice=date_invoice, context=context)
        invoice_id = self.pool.get('account.invoice').browse(cr, uid, result, context=context)
        for o in self.browse(cr, uid, ids, context=context):
            self.pool.get('account.invoice').write(cr, uid, [result], {'new_fiscal_position_id': o.new_fiscal_position_id and o.new_fiscal_position_id.id or False})
            for line in invoice_id.invoice_line:
                fpos_account = self.pool.get('account.fiscal.position').map_account(cr, uid, o.new_fiscal_position_id, line.account_id.id, context=context)
                if fpos_account:
                    self.pool.get('account.invoice.line').write(cr, uid, [line.id], {'account_id': fpos_account})
        invoice_id.button_reset_taxes()
        return result

class sale_order_line(osv.osv):
    _inherit = "sale.order.line"

    def product_id_change(self, cr, uid, ids, pricelist, product, qty=0,
            uom=False, qty_uos=0, uos=False, name='', partner_id=False,
            lang=False, update_tax=True, date_order=False, packaging=False, fiscal_position=False, flag=False, new_fiscal_position_id=None, context=None):
        result = super(sale_order_line, self).product_id_change(cr, uid, ids, pricelist=pricelist, product=product,
            qty=qty, uom=uom, qty_uos=qty_uos, uos=uos, name=name, partner_id=partner_id, lang=lang, update_tax=update_tax,
            date_order=date_order, packaging=packaging, fiscal_position=fiscal_position, flag=flag, context=context)
        if new_fiscal_position_id and result['value'].has_key('tax_id'):
            tax_ids = self.pool.get('account.tax').browse(cr, uid, result['value']['tax_id'])
            new_fpo = self.pool.get('account.fiscal.position').browse(cr, uid, new_fiscal_position_id)
            taxes = self.pool.get('account.fiscal.position').map_tax(cr, uid, new_fpo, tax_ids, context=context)
            result['value']['tax_id'] = taxes
        return result

    def product_id_change_with_wh(self, cr, uid, ids, pricelist, product, qty=0,
            uom=False, qty_uos=0, uos=False, name='', partner_id=False,
            lang=False, update_tax=True, date_order=False, packaging=False, fiscal_position=False, flag=False, warehouse_id=False, new_fiscal_position_id=None, context=None):
        result = super(sale_order_line, self).product_id_change_with_wh(cr, uid, ids, pricelist=pricelist, product=product,
            qty=qty, uom=uom, qty_uos=qty_uos, uos=uos, name=name, partner_id=partner_id, lang=lang, update_tax=update_tax,
            date_order=date_order, packaging=packaging, fiscal_position=fiscal_position, flag=flag, warehouse_id=warehouse_id, context=context)
        if new_fiscal_position_id and result['value'].has_key('tax_id'):
            tax_ids = self.pool.get('account.tax').browse(cr, uid, result['value']['tax_id'])
            new_fpo = self.pool.get('account.fiscal.position').browse(cr, uid, new_fiscal_position_id)
            taxes = self.pool.get('account.fiscal.position').map_tax(cr, uid, new_fpo, tax_ids, context=context)
            result['value']['tax_id'] = taxes
        return result
