# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

from openerp import models, fields, SUPERUSER_ID, api, _
from openerp.osv import osv
from openerp.exceptions import ValidationError
from datetime import datetime

class AccountInvoice(models.Model):
    _inherit = 'account.invoice'

    new_fiscal_position_id = fields.Many2one('account.fiscal.position', string='Temporary fiscal position', readonly=True, states={'draft': [('readonly', False)]})

    @api.multi
    def onchange_partner_id(self, type, partner_id, date_invoice=False,
            payment_term=False, partner_bank_id=False, company_id=False):
        result = super(AccountInvoice, self).onchange_partner_id(type=type, partner_id=partner_id, date_invoice=date_invoice, payment_term=payment_term,
            partner_bank_id=partner_bank_id, company_id=company_id)
        result['value'].update({'new_fiscal_position_id': False})
        date_ref = date_invoice or datetime.now().date().strftime('%Y-%m-%d')
        if partner_id:
            partner_id = self.env['res.partner'].browse(partner_id)
            if partner_id.new_property_account_position:
                from_date = self.env['ir.config_parameter'].sudo().get_param('itis_temporary_fiscal_position.fiscal_position_date_start')
                to_date = self.env['ir.config_parameter'].sudo().get_param('itis_temporary_fiscal_position.fiscal_position_date_stop')
                if from_date and to_date and from_date <= date_ref and to_date >= date_ref:
                    result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
                elif not from_date and to_date and to_date >= date_ref:
                    result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
                elif from_date and not to_date and from_date <= date_ref:
                    result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
                elif not from_date and not to_date:
                    result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
                else:
                    result['value'].update({'new_fiscal_position_id': False})
        return result

    @api.multi
    @api.returns('self')
    def refund(self, date=None, period_id=None, description=None, journal_id=None):
        result = super(AccountInvoice, self).refund(date=date, period_id=period_id, description=description, journal_id=journal_id)
        for invoice in self:
            result.write({'new_fiscal_position_id': invoice.new_fiscal_position_id and invoice.new_fiscal_position_id.id or False})
        return result

    @api.model
    def apply_old_tax(self):
        fiscal_pool = self.env['account.fiscal.position']
        context = dict(self._context)
        for record in self.search([('id', 'in', context.get('active_ids'))]):
            if record.state != 'draft':
                raise ValidationError(_("You can only apply old tax on draft records."))
            new_fiscal_position = record.new_fiscal_position_id
            if new_fiscal_position:
                for line in record.invoice_line:
                    taxes = []
                    for tax in line.invoice_line_tax_id:
                        taxes.append(tax.id)
                        for fo_tax in new_fiscal_position.tax_ids:
                            if fo_tax.tax_dest_id and tax.id == fo_tax.tax_dest_id.id:
                                if tax.id in taxes:
                                    taxes.remove(tax.id)
                                taxes.append(fo_tax.tax_src_id.id)    
                    line.invoice_line_tax_id = [(6, 0, list(set(taxes)))]
                    account_id = line.account_id.id
                    for fo_account in new_fiscal_position.account_ids:
                        if line.account_id.id == fo_account.account_dest_id.id:
                            account_id = fo_account.account_src_id.id
                    line.account_id = account_id
            record.new_fiscal_position_id = False
            record.button_reset_taxes()
        return True

class account_invoice(osv.osv):
    _inherit = 'account.invoice'

    def apply_fiscal_position(self, cr, uid, ids, context=None):
        fiscal_pool = self.pool.get('account.fiscal.position')
        records = self.search(cr, uid, [('id', 'in', context.get('active_ids'))])
        records = self.browse(cr, uid, records, context=context)
        for record in records:
            if record.state != 'draft':
                raise ValidationError(_("You can only apply temporary fiscal position on draft records."))
            
            if record.partner_id.new_property_account_position:
                record.new_fiscal_position_id = record.partner_id.new_property_account_position.id
                for line in record.invoice_line:
                    #set tax
                    tax_ids = fiscal_pool.map_tax(cr, uid, record.partner_id.new_property_account_position, line.invoice_line_tax_id, context=context)
                    line.invoice_line_tax_id = [(6, 0, tax_ids)]
                    #set account
                    fpos_account = fiscal_pool.map_account(cr, uid, record.partner_id.new_property_account_position, line.account_id.id, context=context)
                    if fpos_account:
                        line.account_id = fpos_account
                record.button_reset_taxes()
        return False

class AccountInvoiceLine(models.Model):
    _inherit = 'account.invoice.line'

    @api.model
    def _default_account(self):
        account_id = super(AccountInvoiceLine, self)._default_account()
        if self._context.get('new_fiscal_position_id') and account_id:
            fpos_id = self.env['account.fiscal.position'].sudo().browse(self._context.get('new_fiscal_position_id'))
            fpos_account = fpos_id.map_account(account_id)
            if fpos_account:
                return fpos_account
        return account_id

    account_id = fields.Many2one('account.account', string='Account',
        required=True, domain=[('type', 'not in', ['view', 'closed'])],
        default=_default_account,
        help="The income or expense account related to the selected product.")

    @api.multi
    def product_id_change(self, product, uom_id, qty=0, name='', type='out_invoice',
            partner_id=False, fposition_id=False, price_unit=False, currency_id=False,
            company_id=None, new_fiscal_position_id=None):
        result = super(AccountInvoiceLine, self).product_id_change(product=product, uom_id=uom_id, qty=qty, name=name,
            type=type, partner_id=partner_id, fposition_id=fposition_id, price_unit=price_unit, currency_id=currency_id, company_id=company_id)
        
        if new_fiscal_position_id and result['value'].has_key('invoice_line_tax_id'):
            tax_ids = self.env['account.tax'].browse(result['value']['invoice_line_tax_id'])
            new_fpo = self.env['account.fiscal.position'].browse(new_fiscal_position_id)
            taxes = new_fpo.map_tax(tax_ids)
            result['value']['invoice_line_tax_id'] = [(6, 0, taxes and taxes.ids or [])]
        if new_fiscal_position_id and result['value'].has_key('account_id'):
            new_fpo = self.env['account.fiscal.position'].browse(new_fiscal_position_id)
            account = self.env['account.account'].browse(result['value']['account_id'])
            fpos_account = new_fpo.map_account(account)
            if fpos_account:
                result['value']['account_id'] = fpos_account.id
        return result

    @api.multi
    def uos_id_change(self, product, uom, qty=0, name='', type='out_invoice', partner_id=False,
            fposition_id=False, price_unit=False, currency_id=False, company_id=None, new_fiscal_position_id=None):
        result = super(AccountInvoiceLine, self).uos_id_change(product=product, uom=uom, qty=qty, name=name,
            type=type, partner_id=partner_id, fposition_id=fposition_id, price_unit=price_unit, currency_id=currency_id, company_id=company_id)
        if new_fiscal_position_id and result['value'].has_key('invoice_line_tax_id'):
            tax_ids = self.env['account.tax'].browse(result['value']['invoice_line_tax_id'])
            new_fpo = self.env['account.fiscal.position'].browse(new_fiscal_position_id)
            taxes = new_fpo.map_tax(tax_ids)
            result['value']['invoice_line_tax_id'] = [(6, 0, taxes and taxes.ids or [])]
        if new_fiscal_position_id and result['value'].has_key('account_id'):
            new_fpo = self.env['account.fiscal.position'].browse(new_fiscal_position_id)
            account = self.env['account.account'].browse(result['value']['account_id'])
            fpos_account = new_fpo.map_account(account)
            if fpos_account:
                result['value']['account_id'] = fpos_account.id
        return result

    @api.multi
    def onchange_account_id(self, product_id, partner_id, inv_type, fposition_id, account_id, new_fiscal_position_id=None):
        result = super(AccountInvoiceLine, self).onchange_account_id(product_id=product_id, partner_id=partner_id, inv_type=inv_type, fposition_id=fposition_id,
            account_id=account_id)
        if new_fiscal_position_id and result['value'].has_key('invoice_line_tax_id'):
            tax_ids = self.env['account.tax'].browse(result['value']['invoice_line_tax_id'])
            new_fpo = self.env['account.fiscal.position'].browse(new_fiscal_position_id)
            taxes = new_fpo.map_tax(tax_ids)
            result['value']['invoice_line_tax_id'] = [(6, 0, taxes and taxes.ids or [])]
        return result

class AccountFiscalPosition(models.Model):
    _inherit = 'account.fiscal.position'
    _description = 'Fiscal Position'
    _order = 'sequence'

    related_fiscal_position_id = fields.Many2one('account.fiscal.position', string='Temporary fiscal position')
    default = fields.Boolean(string='Default temp. fiscal position')
