# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

from openerp import models, fields, SUPERUSER_ID, api, _
from openerp.osv import osv
from openerp.exceptions import ValidationError
from datetime import datetime
from openerp.tools import DEFAULT_SERVER_DATETIME_FORMAT, float_compare

class PurchaseOrder(models.Model):
    _inherit = 'purchase.order'

    new_fiscal_position_id = fields.Many2one('account.fiscal.position', string='Temporary fiscal position')

    @api.model
    def apply_old_tax(self):
        fiscal_pool = self.env['account.fiscal.position']
        context = dict(self._context)
        for record in self.search([('id', 'in', context.get('active_ids'))]):
            if record.state != 'draft':
                raise ValidationError(_("You can only apply old tax on draft records."))
            new_fiscal_position = record.new_fiscal_position_id
            if new_fiscal_position:
                for line in record.order_line:
                    taxes = []
                    for tax in line.taxes_id:
                        taxes.append(tax.id)
                        for fo_tax in new_fiscal_position.tax_ids:
                            if fo_tax.tax_dest_id and tax.id == fo_tax.tax_dest_id.id:
                                if tax.id in taxes:
                                    taxes.remove(tax.id)
                                taxes.append(fo_tax.tax_src_id.id)    
                    line.taxes_id = [(6, 0, list(set(taxes)))]
            record.new_fiscal_position_id = False
        return True

class purchase_order(osv.osv):
    _inherit = 'purchase.order'

    def onchange_partner_id(self, cr, uid, ids, partner_id, date_order=None, context=None):
        result = super(purchase_order, self).onchange_partner_id(cr, uid, ids, partner_id=partner_id, context=context)
        partner_id = self.pool.get('res.partner').browse(cr, uid, partner_id, context=context)
        date_ref = datetime.now().strftime('%Y-%m-%d')
        if date_order:
            date_ref = str(datetime.strptime(date_order, DEFAULT_SERVER_DATETIME_FORMAT).date())
        result['value'].update({'new_fiscal_position_id': False})
        if partner_id and partner_id.new_property_account_position:
            from_date = self.pool.get('ir.config_parameter').get_param(cr, SUPERUSER_ID, 'itis_temporary_fiscal_position.fiscal_position_date_start')
            to_date = self.pool.get('ir.config_parameter').get_param(cr, SUPERUSER_ID, 'itis_temporary_fiscal_position.fiscal_position_date_stop')
            if from_date and to_date and from_date <= date_ref and to_date >= date_ref:
                result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
            elif not from_date and to_date and to_date >= date_ref:
                result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
            elif from_date and not to_date and from_date <= date_ref:
                result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
            elif not from_date and not to_date:
                result['value'].update({'new_fiscal_position_id': partner_id.new_property_account_position.id})
            else:
                result['value'].update({'new_fiscal_position_id': False})
        return result

    def apply_fiscal_position(self, cr, uid, ids, context=None):
        fiscal_pool = self.pool.get('account.fiscal.position')
        records = self.search(cr, uid, [('id', 'in', context.get('active_ids'))])
        records = self.browse(cr, uid, records, context=context)
        for record in records:
            if record.state != 'draft':
                raise ValidationError(_("You can only apply temporary fiscal position on draft records."))
            if record.partner_id.new_property_account_position:
                record.new_fiscal_position_id = record.partner_id.new_property_account_position.id
                for line in record.order_line:
                    tax_ids = fiscal_pool.map_tax(cr, uid, record.partner_id.new_property_account_position, line.taxes_id, context=context)
                    line.taxes_id = [(6, 0, tax_ids)]
        return True

    def action_invoice_create(self, cr, uid, ids, context=None):
        result = super(purchase_order, self).action_invoice_create(cr, uid, ids, context=context)
        invoice_id = self.pool.get('account.invoice').browse(cr, uid, result, context=context)
        for order in self.browse(cr, uid, ids, context=context):
            self.pool.get('account.invoice').write(cr, uid, [result], {'new_fiscal_position_id': order.new_fiscal_position_id and order.new_fiscal_position_id.id or False}, context=context)
            for line in invoice_id.invoice_line:
                fpos_account = self.pool.get('account.fiscal.position').map_account(cr, uid, order.new_fiscal_position_id, line.account_id.id, context=context)
                if fpos_account:
                    self.pool.get('account.invoice.line').write(cr, uid, [line.id], {'account_id': fpos_account})
        invoice_id.button_reset_taxes()
        return result
        
class purchase_order_line(osv.osv):
    _inherit = "purchase.order.line"

    def onchange_product_id(self, cr, uid, ids, pricelist_id, product_id, qty, uom_id,
            partner_id, date_order=False, fiscal_position_id=False, date_planned=False,
            name=False, price_unit=False, state='draft', new_fiscal_position_id=None, context=None):
        result = super(purchase_order_line, self).product_id_change(cr, uid, ids, pricelist_id=pricelist_id, product_id=product_id,
            qty=qty, uom_id=uom_id, partner_id=partner_id, date_order=date_order, fiscal_position_id=fiscal_position_id, date_planned=date_planned, 
            name=name, price_unit=price_unit, state=state, context=context)
        if new_fiscal_position_id and result['value'].has_key('taxes_id'):
            tax_ids = self.pool.get('account.tax').browse(cr, uid, result['value']['taxes_id'])
            new_fpo = self.pool.get('account.fiscal.position').browse(cr, uid, new_fiscal_position_id)
            taxes = self.pool.get('account.fiscal.position').map_tax(cr, uid, new_fpo, tax_ids, context=context)
            result['value']['taxes_id'] = taxes
        return result

    def onchange_product_uom(self, cr, uid, ids, pricelist_id, product_id, qty, uom_id,
            partner_id, date_order=False, fiscal_position_id=False, date_planned=False,
            name=False, price_unit=False, state='draft', new_fiscal_position_id=None, context=None):
        result = super(purchase_order_line, self).onchange_product_uom(cr, uid, ids, pricelist_id=pricelist_id, product_id=product_id,
            qty=qty, uom_id=uom_id, partner_id=partner_id, date_order=date_order, fiscal_position_id=fiscal_position_id, date_planned=date_planned, 
            name=name, price_unit=price_unit, state=state, context=context)
        if new_fiscal_position_id and result['value'].has_key('taxes_id'):
            tax_ids = self.pool.get('account.tax').browse(cr, uid, result['value']['taxes_id'])
            new_fpo = self.pool.get('account.fiscal.position').browse(cr, uid, new_fiscal_position_id)
            taxes = self.pool.get('account.fiscal.position').map_tax(cr, uid, new_fpo, tax_ids, context=context)
            result['value']['taxes_id'] = taxes
        return result

