# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.


from openerp import models, fields, api, _
from openerp.osv import fields, osv
from datetime import datetime


class ResPartner(osv.osv):
    _inherit = 'res.partner'

    _columns = {
        'new_property_account_position': fields.property(
            type='many2one',
            relation='account.fiscal.position',
            string="Temporary fiscal position",
            help="The fiscal position will determine taxes and accounts used for the partner.",
        ),
    }

class ResPartner(models.Model):
    _inherit = 'res.partner'

    @api.model
    def set_new_fiscal_position(self):
        date_ref = datetime.now().date().strftime('%Y-%m-%d')
        fiscal_pool = self.env['account.fiscal.position']
        context = dict(self._context)
        records = self.search([('id', 'in', context.get('active_ids'))])
        for record in records:
            if record.property_account_position and record.property_account_position.related_fiscal_position_id:
                record.new_property_account_position = record.property_account_position.related_fiscal_position_id.id or False
            elif not record.property_account_position:
                fiscal_id = fiscal_pool.sudo().search([('default', '!=', False)], limit=1)
                if fiscal_id:
                    record.new_property_account_position = fiscal_id.id
        return True

    @api.model
    def remove_new_fiscal_position(self):
        context = dict(self._context)
        records = self.search([('id', 'in', context.get('active_ids'))])
        for record in records:
            record.new_property_account_position = False
            for child in record.child_ids:
                child.new_property_account_position = False
                related_ids = self.search([('parent_id', '=', child.id)])
                for related in related_ids:
                    related.new_property_account_position = False
        return True

    @api.multi
    def set_new_property_account_position(self, new_property_account_position=False):
        for child in self.child_ids:
            child.new_property_account_position = new_property_account_position
            related_ids = self.search([('parent_id', '=', child.id)])
            for related in related_ids:
                related.new_property_account_position = new_property_account_position

    @api.multi
    def write(self, values):
        res = super(ResPartner, self).write(values)
        if values.get('new_property_account_position'):
            for record in self:
                record.set_new_property_account_position(new_property_account_position=values.get('new_property_account_position'))
        return res

    # @api.model
    # def default_get(self, fields):
    #     fiscal_pool = self.env['account.fiscal.position']
    #     defaults = super(ResPartner, self).default_get(fields)
    #     date_ref = datetime.now().date().strftime('%Y-%m-%d')
    #     from_date = self.pool.get('ir.config_parameter').get_param(cr, SUPERUSER_ID, 'itis_temporary_fiscal_position.fiscal_position_date_start')
    #         to_date = self.pool.get('ir.config_parameter').get_param(cr, SUPERUSER_ID, 'itis_temporary_fiscal_position.fiscal_position_date_stop')
    #     if defaults.get('property_account_position'):
    #         property_account_position = fiscal_pool.browse(defaults.get('property_account_position'))
    #         if property_account_position.related_fiscal_position_id:
    #             if (from_date and to_date and from_date <= date_ref and to_date >= date_ref) or (not from_date and to_date and to_date >= date_ref) or (from_date and not to_date and from_date <= date_ref) or (not from_date and not to_date):
    #                 defaults['new_property_account_position'] = property_account_position.related_fiscal_position_id.id
    #     elif not defaults.get('property_account_position'):
    #         fiscal_id = fiscal_pool.sudo().search([('default', '!=', False)], limit=1)
    #         if fiscal_id:
    #             if (from_date and to_date and from_date <= date_ref and to_date >= date_ref) or (not from_date and to_date and to_date >= date_ref) or (from_date and not to_date and from_date <= date_ref) or (not from_date and not to_date):                
    #                 defaults['new_property_account_position'] = fiscal_id.id
    #     return defaults
