# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.


from odoo import api, fields, models, _


class SaleAdvancePaymentInv(models.TransientModel):
    _inherit = "sale.advance.payment.inv"
    _description = "Sales Advance Payment Invoice"

    @api.multi
    def _create_invoice(self, order, so_line, amount):
        invoice = super(SaleAdvancePaymentInv, self)._create_invoice(order=order, so_line=so_line, amount=amount)
        invoice.new_fiscal_position_id = order.new_fiscal_position_id and order.new_fiscal_position_id.id or False
        if invoice.new_fiscal_position_id:
            for line in invoice.invoice_line_ids:
                account_id = invoice.new_fiscal_position_id.map_account(line.account_id)
                if account_id:
                    line.account_id = account_id.id
                taxes = line.invoice_line_tax_ids
                line.invoice_line_tax_ids = invoice.new_fiscal_position_id.map_tax(taxes, line.product_id, line.invoice_id.partner_id)
        invoice.compute_taxes()
        return invoice
