# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

from odoo import models, fields, api, _
from odoo.http import request


class Website(models.Model):
    _inherit = 'website'

    @api.multi
    def sale_get_order(self, force_create=False, code=None, update_pricelist=False, force_pricelist=False):
        partner = self.env.user.partner_id
        sale_order = super(Website, self).sale_get_order(force_create=force_create, code=code, update_pricelist=update_pricelist, force_pricelist=force_pricelist)
        if sale_order and force_create or code:
            # set fiscal position
            sale_order.onchange_partner_id()
            sale_order.onchange_partner_shipping_id()
        return sale_order